if not (THEME:GetCurThemeName() == 'default') then
	SCREENMAN:SystemMessage("Please switch your theme to default in order to play this file.")
	return Def.ActorFrame{}
end

local songName= GAMESTATE:GetCurrentSong():GetSongDir()

local sw = SCREEN_WIDTH;
local sh = SCREEN_HEIGHT;

local function mod_internal(str, pn)
	local ps= GAMESTATE:GetPlayerState(pn)
	local pmods= ps:GetPlayerOptionsString('ModsLevel_Song')
	ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
	--GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function mod(str)
	for i=1,2 do
		mod_internal(str, 'PlayerNumber_P' .. i)
	end
end

local function init()
	fgcurcommand = 1;
	checked = false;
			
	mod_firstSeenBeat = GAMESTATE:GetSongBeat()
			
--lua course :D
curmod = 1;
--{beat,mod,player}
mods = {

{0, '2.25x,*99 dark,*99 drunk,*99 tipsy,*99 confusion,*99 cover'},
{84, '*0.5 no dark,*0.3 no drunk,*0.3 no tipsy,*0.4 no confusion'},
{93, '*99 -1000% cover'},
{165, '*4 reverse,*4 dark,*4 stealth'},
{166, '*99 no dark,*99 no stealth'},
{173, '*4 no reverse,*4 dark,*4 stealth'},
{174, '*99 no dark,*99 no stealth'},
{181, '*4 split,*4 dark,*4 stealth'},
{182, '*99 no dark,*99 no stealth'},
{188, '*4 no split'},
{189, '-500% Reverse,Centered,*10000 0.3x,*8 1000% Bumpy,-70% SuddenOffset,*4 Sudden,55% Distant'},
{205, '*0.2 -200% tiny'},
{221, '*99 dark,*99 stealth,*99 no reverse,*99 no centered,*99 2.25x,*99 no bumpy,*99 no sudden,*99 overhead,*99 no suddenoffset,*99 no tiny'},
{225, '*99 no stealth'},
{237, '*99 1000% beat'},
{237.25, '*1000 no beat'},
{241, '*99 -1000% beat'},
{241.25, '*1000 no beat'},
{243, '*99 1000% beat'},
{243.25, '*1000 no beat'},
{245, '*99 -1000% beat'},
{245.25, '*1000 no beat'},
{253, '*99 no dark,*99 -50% flip'},
{261, '*99 70% distant',2},
{269, '*99 70% hallway',1},
{277, '*99 70% incoming',2},
{285, '*99 overhead'},
{286, '*0.1 -200% tiny'},
{317, '*99 no tiny,*99 no flip,*99 55% stealth'},
{317.1, '*0.1 tiny'},
{345, '*0.5 stealth,*2 -300% tiny,*2 cover'},
{348, '*1000 9999% drunk,*4 dark,*1000 -500% tiny'}



}

prefix_plr = {};

introshit={{3,4},{12,13},{20,21},{29,30},{38,39},{47,48},{56,57},{69,70}}

for i,v in pairs(introshit) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, '*99 no dark'})
        table.insert(mods, {beat + 0.25, '*2 dark'})
    end
end

for beat=158,187,4 do
	table.insert(mods, {beat, '*1000 500% drunk'})
	table.insert(mods, {beat + 0.25, '*16 no drunk'})
end

for beat=158,187,2 do
	table.insert(mods, {beat, '*1000 -500% drunk'})
	table.insert(mods, {beat + 0.25, '*16 no drunk'})
end

swapyeah={{254,260},{262,268},{270,276},{278,284}}

for i,v in pairs(swapyeah) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, '*32 200% invert'})
        table.insert(mods, {beat + 0.25, '*32 -200% invert'})
		table.insert(mods, {beat + 0.5, '*32 200% invert,*32 -50% flip'})
		table.insert(mods, {beat + 0.75, '*32 no invert'})
    end
end

curaction = 1;
--{beat,action,persist}
actions = {
	{93,function()
		if P1 then P1:rotationz(-20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
		if P2 then P2:rotationz(-20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
	end},
	{94.5,function()
		if P1 then P1:rotationz(20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
		if P2 then P2:rotationz(20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
	end},
	{97,function()
		if P1 then P1:rotationz(-20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
		if P2 then P2:rotationz(-20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
	end},
	{98.5,function()
		if P1 then P1:rotationz(20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
		if P2 then P2:rotationz(20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
	end},
	{101,function()
		if P1 then P1:rotationz(-20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
		if P2 then P2:rotationz(-20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
	end},
	{102.5,function()
		if P1 then P1:rotationz(20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
		if P2 then P2:rotationz(20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
	end},
	{105,function()
		if P1 then P1:rotationz(-20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
		if P2 then P2:rotationz(-20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
	end},
	{107,function()
		if P1 then P1:rotationz(20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
		if P2 then P2:rotationz(20):zoom(0.8):decelerate(0.5):rotationz(0):zoom(1) end
	end},
	{109, function()
		SCREENMAN:GetTopScreen():vibrate():effectmagnitude(20, 20, 20) end},
	{109.25, function()
		SCREENMAN:GetTopScreen():stopeffect() end},
	{110.5, function()
		SCREENMAN:GetTopScreen():vibrate():effectmagnitude(20, 20, 20) end},
	{110.75, function()
		SCREENMAN:GetTopScreen():stopeffect() end},
	{113, function()
		SCREENMAN:GetTopScreen():vibrate():effectmagnitude(20, 20, 20) end},
	{113.25, function()
		SCREENMAN:GetTopScreen():stopeffect() end},
	{114.5, function()
		SCREENMAN:GetTopScreen():vibrate():effectmagnitude(20, 20, 20) end},
	{114.75, function()
		SCREENMAN:GetTopScreen():stopeffect() end},
	{117, function()
		SCREENMAN:GetTopScreen():vibrate():effectmagnitude(20, 20, 20) end},
	{117.25, function()
		SCREENMAN:GetTopScreen():stopeffect() end},
	{118.5, function()
		SCREENMAN:GetTopScreen():vibrate():effectmagnitude(20, 20, 20) end},
	{118.75, function()
		SCREENMAN:GetTopScreen():stopeffect() end},
	{125, function()
		SCREENMAN:GetTopScreen():vibrate():effectmagnitude(20, 20, 20) end},
	{158, function()
		SCREENMAN:GetTopScreen():stopeffect() end},
	{125,function()
		if P1 then P1:linear(15):zoomy(0) end
		if P2 then P2:linear(15):zoomy(0) end
	end},
	{158,function()
		if P1 then P1:zoomy(1) end
		if P2 then P2:zoomy(1) end
	end},
	{253,function()
		local multi = -1; if P2 then multi = 1; end
			if P1 then P1:x(SCREEN_CENTER_X+32*-multi) end
			if P2 then P2:x(SCREEN_CENTER_X+32*multi) end
	end},
	{286,function()
		if P1 then P1:vibrate():effectmagnitude(20, 20, 20) end
		if P2 then P2:vibrate():effectmagnitude(20, 20, 20) end
	end},
	{293,function()
		if P1 then P1:stopeffect() end
		if P2 then P2:stopeffect() end
	end},
	{294,function()
		if P1 then P1:vibrate():effectmagnitude(40, 40, 40) end
		if P2 then P2:vibrate():effectmagnitude(40, 40, 40) end
	end},
	{301,function()
		if P1 then P1:stopeffect() end
		if P2 then P2:stopeffect() end
	end},
	{302,function()
		if P1 then P1:vibrate():effectmagnitude(60, 60, 60) end
		if P2 then P2:vibrate():effectmagnitude(60, 60, 60) end
	end},
	{309,function()
		if P1 then P1:stopeffect() end
		if P2 then P2:stopeffect() end
	end},
	{310,function()
		if P1 then P1:vibrate():effectmagnitude(80, 80, 80) end
		if P2 then P2:vibrate():effectmagnitude(80, 80, 80) end
	end},
	{317,function()
		if P1 then P1:stopeffect():x(SCREEN_WIDTH/4) end
		if P2 then P2:stopeffect():x(SCREEN_WIDTH*3/4) end
	end},




}

--SCREAMING GUMBALL
curmessage = 1;
--{beat,message,{params},persist?}
messages = {
{0, 'StartTrail'},
{93, 'StopTrail'},
{109, 'Changethebeatofthesongplease'},
{110.5, 'Changethebeatofthesongplease'},
{113, 'Changethebeatofthesongplease'},
{114.5, 'Changethebeatofthesongplease'},
{117, 'Changethebeatofthesongplease'},
{118.5, 'Changethebeatofthesongplease'},
{121, 'Changethebeatback'},
{125, 'Flame'},
{158, 'StopTrail'},
{189, 'StartTrail'},
{249, 'VibbAFT'},
{253, 'StopVibb'},
{253, 'StopTrail'},
{348, 'OwO'}
}


	function modtable_compare(a,b)
		return a[1] < b[1]
	end
	
	if table.getn(mods) > 1 then
		table.sort(mods, modtable_compare)
	end
	
	if table.getn(messages) > 1 then
		table.sort(messages, modtable_compare)
	end
	
	if table.getn(actions) > 1 then
		table.sort(actions, modtable_compare)
	end
	
	if table.getn(actions) > 1 then
		table.sort(actions, modtable_compare)
	end
	
end

local function update(self, delta)

	if GAMESTATE:GetSongBeat()>=0.1 and not checked then
		
		P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
		P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
		
		checked = true;
		
	end
	
	local beat = GAMESTATE:GetSongBeat()
	
	
	-- Collect all the mods that will be applied in this frame into one string.
	-- Mod tweening doesn't work correctly if the mods are in seperate commands.
	local mods_this_frame= {}
	local function add_mod(mod_str)
		mods_this_frame[#mods_this_frame+1]= mod_str
	end
	local function execute_mods()
		if #mods_this_frame <= 0 then return end
		local total_mod_str= ""
		for i, ms in ipairs(mods_this_frame) do
			if #total_mod_str > 0 then
				total_mod_str= total_mod_str .. ", "
			end
			total_mod_str= total_mod_str .. ms
		end
		mod(total_mod_str)
	end
	
	while curmod<= #mods and GAMESTATE:GetSongBeat()>=mods[curmod][1] do
		if table.getn(mods[curmod]) < 3 then
			add_mod(mods[curmod][2])
		else
			mod_internal(mods[curmod][2], 'PlayerNumber_P' .. mods[curmod][3])
		end
		curmod = curmod+1
	end

	execute_mods()
	
	for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
                SCREENMAN:GetTopScreen():GetChild('ScoreP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('BPMDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('StageDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('SongTitle'):visible(false);
				SCREENMAN:GetTopScreen():GetChild("SongMeterDisplay" .. PlayerNumberToString(i-1)):visible(false);
				SCREENMAN:GetTopScreen():GetChild("StepsDisplay" .. PlayerNumberToString(i-1)):visible(false);
				SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment'):x(-140):zoom(0.75);
				SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment'):x(140):zoom(0.75);
				SCREENMAN:GetTopScreen():GetChild('PlayerP'..i):GetChild('Combo'):visible(false);
			end
	
	
	
	
	--SCREAMING GUMBALL
	while curmessage<= #messages and GAMESTATE:GetSongBeat()>=messages[curmessage][1] do
		if messages[curmessage][4] and GAMESTATE:GetSongBeat()>=messages[curmessage][1]+5 then
			curmessage = curmessage+1;
		else
			MESSAGEMAN:Broadcast(messages[curmessage][2],messages[curmessage][3])
			curmessage = curmessage+1;
		end
	end
	
	while curaction<= #actions and GAMESTATE:GetSongBeat()>=actions[curaction][1] do
		if actions[curaction][3] or GAMESTATE:GetSongBeat() < actions[curaction][1]+2 then
			actions[curaction][2]()
		end
		curaction = curaction+1;
	end
	
end

local t = Def.ActorFrame{
	OnCommand= function(self)
							 init()
							 self:SetUpdateFunction(update)
							 self:fov(90);
						 end,
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},
	Def.Quad{
		InitCommand=function(self) vibquad = self end,
		OnCommand= cmd(x,0),
	},
	
}

t[#t+1] = Def.Quad{
	OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,0,0,0,0),
	
	ChangethebeatofthesongpleaseMessageCommand= function(self)
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):addx(math.random(-50,50));
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):rotationx(math.random(-50,50));
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):rotationy(math.random(-50,50));
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):rotationz(math.random(-50,50));
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):addx(math.random(-50,50));
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):rotationx(math.random(-50,50));
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):rotationy(math.random(-50,50));
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):rotationz(math.random(-50,50));
		end,
		
	ChangethebeatbackMessageCommand= function(self)
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):smooth(1);
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):x(SCREEN_WIDTH/4);
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):rotationx(0);
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):rotationy(0);
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):rotationz(0);
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):smooth(1);
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):x(SCREEN_WIDTH*3/4);
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):rotationx(0);
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):rotationy(0);
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):rotationz(0);
		end,
}

--------------
-- P1 GHOST --
--------------
t[#t+1] = 
	Def.ActorFrameTexture{
		Name = "MemoryP1";
		InitCommand=function(self)
			self:SetTextureName( "MemoryP1" )
			self:SetWidth( sw );
			self:SetHeight( sh );
			self:EnableAlphaBuffer( true );
			self:Create();
		end;
		Def.Sprite{ Name = "Sprite"; InitCommand=cmd(Center) };
	};

t[#t+1] = 
	Def.ActorFrameTexture{
		InitCommand=function(self)
			self:SetTextureName( "OutputP1" )
			self:SetWidth( sw ); -- change these to simulate textures being drawn away from source
			self:SetHeight( sh ); -- change these to simulate textures being drawn away from source
			self:EnableAlphaBuffer( true );
			self:Create();
			self:GetParent():GetChild("MemoryP1"):GetChild("Sprite"):SetTexture( self:GetTexture() );
		end;
		Def.Sprite{	Texture = "MemoryP1"; InitCommand=cmd(Center;diffuse,1,1,1,0;visible,true); 
			StopTrailMessageCommand=cmd(diffuse,1,1,1,0);
			StartTrailMessageCommand=cmd(diffuse,1,1,1,0.99);
			FlameMessageCommand=cmd(diffuse,255,140,0,0.99);
			VibbAFTMessageCommand=cmd(vibrate,1;effectmagnitude,35,35,35);
			StopVibbMessageCommand=cmd(stopeffect,1);
			OwOMessageCommand=cmd(diffuse,1,1,1,1);
		};
		Def.ActorProxy{
			BeginCommand=function(self)
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP1');
				self:SetTarget(p);
			end,
			OnCommand=function(self)
				self:x(0);
				self:y(0);
			end
		};
	};
	
t[#t+1] = 
	Def.Sprite{
		Name = "GhostingP1";
		Texture = "OutputP1";
		InitCommand=cmd(Center);
	};

--------------
-- P2 GHOST --
--------------
t[#t+1] = 
	Def.ActorFrameTexture{
		Name = "MemoryP2";
		InitCommand=function(self)
			self:SetTextureName( "MemoryP2" )
			self:SetWidth( sw );
			self:SetHeight( sh );
			self:EnableAlphaBuffer( true );
			self:Create();
		end;
		Def.Sprite{ Name = "Sprite"; InitCommand=cmd(Center) };
	};

t[#t+1] = 
	Def.ActorFrameTexture{
		InitCommand=function(self)
			self:SetTextureName( "OutputP2" )
			self:SetWidth( sw ); -- change these to simulate textures being drawn away from source
			self:SetHeight( sh ); -- change these to simulate textures being drawn away from source
			self:EnableAlphaBuffer( true );
			self:Create();
			self:GetParent():GetChild("MemoryP2"):GetChild("Sprite"):SetTexture( self:GetTexture() );
		end;
		Def.Sprite{	Texture = "MemoryP2"; InitCommand=cmd(Center;diffuse,1,1,1,0;visible,true); 
			StopTrailMessageCommand=cmd(diffuse,1,1,1,0);
			StartTrailMessageCommand=cmd(diffuse,1,1,1,0.99);
			FlameMessageCommand=cmd(diffuse,255,140,0,0.99);
			VibbAFTMessageCommand=cmd(vibrate,1;effectmagnitude,35,35,35);
			StopVibbMessageCommand=cmd(stopeffect,1);
			OwOMessageCommand=cmd(diffuse,1,1,1,1);
		};
		Def.ActorProxy{
			BeginCommand=function(self)
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP2');
				self:SetTarget(p);
			end,
			OnCommand=function(self)
				self:x(0);
				self:y(0);
			end
		};
	};
	
t[#t+1] = 
	Def.Sprite{
		Name = "GhostingP2";
		Texture = "OutputP2";
		InitCommand=cmd(Center);
	};



return t